<?php
 
include_once 'conexao.php';
   
class ModeloSalaParaVideoConferencia  
{    
	static public function mdlAddSalaParaVideoConferencia($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO salaparavideoconferencia 
						(sala, dataCadastro,chaveDaSala) VALUES 
						(:sala, :dataCadastro,:chaveDaSala)");
		
		$stmt->bindParam(":sala", $dados["sala"], PDO::PARAM_STR);
		$stmt->bindParam(":chaveDaSala", $dados["chaveDaSala"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlAddAulaEmDireto($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO aulaemdireito 
						(idCurso,estado, dataInicio,idSala,dataTermino) VALUES 
						(:idCurso,:estado, :dataInicio,:idSala,:dataTermino)");
		
		$stmt->bindParam(":idCurso", $dados["idCurso"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $dados["estado"], PDO::PARAM_STR);
		$stmt->bindParam(":idSala", $dados["idSala"], PDO::PARAM_STR);
		$stmt->bindParam(":dataInicio", $dados["dataInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":dataTermino", $dados["dataTermino"], PDO::PARAM_STR);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
	
	static public function mdlMostrarTodasSalas() {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM salaparavideoconferencia ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}  

	static public function mdlMostrarSalaPorChave($chaveDaSala) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM salaparavideoconferencia where 	chaveDaSala = :chaveDaSala");
			$stmt->bindParam(":chaveDaSala", $chaveDaSala, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}


	static public function mdlMostrarSalaPorIdSala($idSala) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM salaparavideoconferencia where 	idSalaParaLive = :idSalaParaLive");
			$stmt->bindParam(":idSalaParaLive", $idSala, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarSalaPorIdUsuario($idUsuario) {

		$resultado = array();  

			$stmt = Conexao::conectar()->prepare("SELECT * FROM salaparavideoconferencia where idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
	
	static public function mdlMostrarSalaPorIdUsuarioEIdSala($idUsuario,$idSala) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM salaparavideoconferencia where idSalaParaLive = :idSalaParaLive and idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt->bindParam(":idSalaParaLive", $idSala, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlLimparSalasNulas() {
		$limiteUsuario = NULL;
		$usuario = NULL;
	
		$stmt = Conexao::conectar()->prepare("UPDATE salaparavideoconferencia SET limiteUsusario = :limiteUsuario, horaFinal = '', horaInicio = '', idUsuario = '', dataReuniao = '' WHERE (idUsuario = '' OR idUsuario IS NULL) AND horaInicio != ''");
	
		$stmt->bindParam(':limiteUsuario', $limiteUsuario, PDO::PARAM_INT);
	
		if ($stmt->execute()) {
			return "ok";
		} else {
			return "error";
		}
	}
	

	static public function mdlEditarProprietarioDaSalaLimiteUsuarioHoraInicioeHoraTerminoDataReuniao($idSalaParaLive, $horaInicio, $horaFinal, $limiteUsusario, $idUsuario, $dataReuniao){
 
		$stmt = Conexao::conectar()->prepare("UPDATE salaparavideoconferencia SET limiteUsusario = :limiteUsusario, horaFinal = :horaFinal, horaInicio = :horaInicio, idUsuario = :idUsuario, dataReuniao = :dataReuniao where idSalaParaLive = :idSalaParaLive");
		$stmt->bindParam(":horaInicio", $horaInicio, PDO::PARAM_STR);
		$stmt->bindParam(":idSalaParaLive", $idSalaParaLive, PDO::PARAM_STR);
		$stmt->bindParam(":horaFinal", $horaFinal, PDO::PARAM_STR);
		$stmt->bindParam(":limiteUsusario", $limiteUsusario, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		$stmt->bindParam(":dataReuniao", $dataReuniao, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}
 
	static public function mdlEditarDadosDaSala($idSalaParaLive, $sala, $chaveDaSala, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("UPDATE salaparavideoconferencia SET sala = :sala, chaveDaSala = :chaveDaSala, idUsuario = :idUsuario  where idSalaParaLive = :idSalaParaLive ");
		$stmt->bindParam(":idSalaParaLive", $idSalaParaLive, PDO::PARAM_STR);
		$stmt->bindParam(":sala", $sala, PDO::PARAM_STR);
		$stmt->bindParam(":chaveDaSala", $chaveDaSala, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	

	static public function mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET idModeloCertificado = :idModeloCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idModeloCertificado", $idModeloCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>